<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<!-- Class Hierarchy for package -->
	<xsl:template name="PackageClassTree">
		<xsl:param name="package"></xsl:param>
		<xsl:param name="classes"></xsl:param>
		<xsl:param name="sublevelClasses"></xsl:param>
		
		<xsl:if test="$classes">
			<ul>
			<xsl:for-each select="$classes">
				<xsl:sort select="@name"></xsl:sort>	
				<xsl:variable name="id" select="@id"></xsl:variable>

				<li type="circle"/>
				<xsl:variable name="tclass">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'tclass'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$tclass"></xsl:value-of>
				
				<xsl:variable name="parentQName">
					<xsl:apply-templates select="current()" mode="parentQualifiedName">
					</xsl:apply-templates>
				</xsl:variable>
				<xsl:value-of select="$parentQName"></xsl:value-of>

				<xsl:if test="string-length($parentQName) &gt; 0">
					<xsl:text>.</xsl:text>
				</xsl:if>
	
				<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
				
				<xsl:variable name="implements" select="current()/Implements"></xsl:variable>
				<xsl:if test="$implements">
					<xsl:text> (</xsl:text>
					<xsl:variable name="timplements">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'timplements'"></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select="$timplements"></xsl:value-of>
					
					<xsl:for-each select="$implements">
						<xsl:variable name="interface" select="key('classifier',@idref)"></xsl:variable>
						<xsl:choose>
							<xsl:when test="$interface">
								<xsl:variable name="iparentQName">
									<xsl:apply-templates select="$interface" mode="parentQualifiedName">
									</xsl:apply-templates>
								</xsl:variable>
								<xsl:if test="string-length($iparentQName) &gt; 0">
									<xsl:value-of select="$iparentQName"></xsl:value-of>
									<xsl:text>.</xsl:text>
								</xsl:if>
								
								<xsl:apply-templates select="$interface" mode="HRefWithImgLoad"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@refFN"/>
							</xsl:otherwise>
						</xsl:choose>

						<xsl:if test="not(position()=last())">
							<xsl:text>, </xsl:text>
						</xsl:if>
						
					</xsl:for-each>
					<xsl:text>)</xsl:text>
				</xsl:if>

				<xsl:call-template name="PackageClassTree">
					<xsl:with-param name="classes" select="$sublevelClasses[Extends[@idref=$id]]"></xsl:with-param>
					<xsl:with-param name="sublevelClasses" select="$sublevelClasses[Extends[not(@idref=$id)]]"></xsl:with-param>
				</xsl:call-template>
			
			</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>

	<!-- Interface hierarchy for package -->
	<xsl:template name="PackageInterfaceTree">
		<xsl:param name="package"></xsl:param>
		<xsl:param name="interfaces"></xsl:param>
		<xsl:param name="sublevelInterfaces"></xsl:param>
		
		<xsl:if test="$interfaces">
			<ul>
			<xsl:for-each select="$interfaces">
				<xsl:sort select="@name"></xsl:sort>	
				<xsl:variable name="id" select="@id"></xsl:variable>

				<li type="circle"/>
				<xsl:variable name="tinterface">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'tinterface'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$tinterface"></xsl:value-of>

				<xsl:variable name="parentQName">
					<xsl:apply-templates select="current()" mode="parentQualifiedName">
					</xsl:apply-templates>
				</xsl:variable>
				<xsl:value-of select="$parentQName"></xsl:value-of>
				<xsl:if test="string-length($parentQName) &gt; 0">
					<xsl:text>.</xsl:text>
				</xsl:if>
				
				<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
			
				<xsl:call-template name="PackageInterfaceTree">
					<xsl:with-param name="interfaces" select="$sublevelInterfaces[Extends[@idref=$id]]"></xsl:with-param>
					<xsl:with-param name="sublevelInterfaces" select="$sublevelInterfaces[Extends[not(@idref=$id)]]"></xsl:with-param>
				</xsl:call-template>
			
			</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>

	<!-- Calculates parent qualified name -->
	<xsl:template match="Classifier" mode="parentQualifiedName">
			<xsl:variable name="parentsNodeSet" select="ancestor::Package | ancestor::Classifier"/>
			<xsl:variable name="parentQualifiedName">
				<xsl:for-each select="$parentsNodeSet">
					<xsl:value-of select="@name"/>
					<xsl:if test="not(position()=last())">.</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:value-of select="$parentQualifiedName"></xsl:value-of>
	</xsl:template>

	<!-- Resolves path for package-tree.html -->
	<xsl:template name="treePathResolver">
		<xsl:param name="element"></xsl:param>

		<xsl:variable name="fullPath">
			<!--xsl:apply-templates select="$element" mode="getFullPath"></xsl:apply-templates-->
			<xsl:apply-templates select="$element" mode="getRelativePath"></xsl:apply-templates>
		</xsl:variable>
		<!--xsl:value-of select="concat('file:///', $fullPath, '/package-tree.html')"></xsl:value-of-->
		<xsl:value-of select="concat($fullPath, '/package-tree.html')"></xsl:value-of>
	</xsl:template>

</xsl:stylesheet>
